/******************************************************************************/
/******************************************************************************/

//  FiveCo        Innovative Engineering

//  Switzerland                     2006

/******************************************************************************/
/******************************************************************************/
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
//---------------------------------------------------------------------------
#include "MainForm.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//      Form constructor and destructor
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
    ComID_MAIN = NULL;
    ComID_RS232 = NULL;

    QueryPerformanceFrequency(&Frequency);
    Cpt = 0;
}
//---------------------------------------------------------------------------
__fastcall TForm1::~TForm1()
{
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//      MAIN PORT Callback functions
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void    TForm1::Data_Received_MAIN(FMod_SRegisterListRead *RegList, void *ComID)
{
    if(RegList->INPUTS_Read)
    {
        // Get the time between 2 receive data to evaluate Repetitve ask precision
        QueryPerformanceCounter(&Time2);

        // Display result in [ms]
        if(++Cpt >= 100)
        {
            Val = 1000*((Time2.QuadPart - Time1.QuadPart)/(double)Frequency.QuadPart);
            LTimeRepet->Caption = FloatToStrF(Val, (TFloatFormat)2, 6, 4);
            Cpt=0;
        }

        QueryPerformanceCounter(&Time1);
    }


    // check wich value has been updated

    if(RegList->IPADDRESS_Read)
        MemoComMain->Lines->Add("IPADDRESS = "+IntToStr(RegList->IPADDRESS[0])+"."
                                                +IntToStr(RegList->IPADDRESS[1])+"."
                                                  +IntToStr(RegList->IPADDRESS[2])+"."
                                                    +IntToStr(RegList->IPADDRESS[3]));

    if(RegList->TCPTIMEOUT_Read)
        MemoComMain->Lines->Add("TCPTIMEOUT = "+IntToStr(RegList->TCPTIMEOUT));
    if(RegList->TCPTIMEOUT_Written)
        MemoComMain->Lines->Add("TCPTIMEOUT Written");
}
//---------------------------------------------------------------------------
void    TForm1::Com_Event_MAIN(int State, void *ComID)
{
    // Display state in the status bar
    AnsiString StateStr;

    TranslateState(State, &StateStr);

    SBComMain->Panels->Items[1]->Text = StateStr;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//      MAIN PORT Interface functions
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void __fastcall TForm1::BOpenComMainClick(TObject *Sender)
{
    int Add[4] = {StrToInt(EAddress1ComMain->Text), StrToInt(EAddress2ComMain->Text), StrToInt(EAddress3ComMain->Text), StrToInt(EAddress4ComMain->Text)};

    if(!FMod_TCP_BOX_OpenConnection_MAINPORT(Add, Data_Received_MAIN, Com_Event_MAIN, &ComID_MAIN))
        SBComMain->Panels->Items[1]->Text = "Open failed";    
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BCloseComMainClick(TObject *Sender)
{
    FMod_TCP_BOX_CloseConnection(&ComID_MAIN);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BSendRComMainClick(TObject *Sender)
{
    // Set wich register will be Read
    FMod_TCP_BOX_Read_IPADDRESS(ComID_MAIN);
    FMod_TCP_BOX_Read_TCPTIMEOUT(ComID_MAIN);

    // Send data to the connected module
    FMod_TCP_BOX_SendData_MAINPORT(ComID_MAIN);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BSendWComMainClick(TObject *Sender)
{
    // Set wich register will be written
    FMod_TCP_BOX_Write_TCPTIMEOUT(50, ComID_MAIN);

    // Send data to the connected module
    FMod_TCP_BOX_SendData_MAINPORT(ComID_MAIN);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BSendRWComMainClick(TObject *Sender)
{
    // Set wich register will be Read and written
    FMod_TCP_BOX_Read_IPADDRESS(ComID_MAIN);
    FMod_TCP_BOX_Write_TCPTIMEOUT(30, ComID_MAIN);

    // Send data to the connected module
    FMod_TCP_BOX_SendData_MAINPORT(ComID_MAIN);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BSendI2CMainClick(TObject *Sender)
{
    // Makes the I2C Buffer
    Byte BufI2C[180];

    BufI2C[0] = 0x20;
    BufI2C[1] = 0x01;
    BufI2C[2] = 0x00;
    BufI2C[3] = 0x04;

    // Set I2C Register data to send
    FMod_TCP_BOX_ReadWriteI2C(BufI2C, 4, false, 200, ComID_MAIN);

    // Send data to the connected module
    FMod_TCP_BOX_SendData_MAINPORT(ComID_MAIN);
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//      Repetitive Ask Functions
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void __fastcall TForm1::BStartRepetClick(TObject *Sender)
{
    // First reset the repetitve ask values
    FMod_TCP_BOX_RepetitiveAskReset(ComID_MAIN);

    // Read IOVALUE0 in continuous
    FMod_TCP_BOX_Read_INPUTS(true, ComID_MAIN);

    // Start the repetitive ask
    FMod_TCP_BOX_RepetitiveAskStart(ComID_MAIN);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BStopRepetClick(TObject *Sender)
{
    // Stop the repetitive ask
    FMod_TCP_BOX_RepetitiveAskStop(ComID_MAIN);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BSetTimeRepetClick(TObject *Sender)
{
    // Set the time of repetition
    FMod_TCP_BOX_RepetitiveAskSetTime(StrToInt(ETimeRepet->Text), ComID_MAIN);
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//      RS232 PORT Callback functions
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void TForm1::Data_Received_RS232(int NbByte, void *ComID)
{
    int DataLength = RECEIVEBUFFERSIZE;

    FMod_TCP_BOX_GetData_RS232(DataReceived_RS232, &DataLength, ComID);

    AnsiString Temp="";

    for(int i=0; i<DataLength; i++)
        Temp += (char)DataReceived_RS232[i];

    MemoComRS232->Lines->Add(Temp);
}
//---------------------------------------------------------------------------
void TForm1::Com_Event_RS232(int State, void *ComID)
{
    // Display state in the status bar
    AnsiString StateStr;

    TranslateState(State, &StateStr);

    SBComRS232->Panels->Items[1]->Text = StateStr;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//      MAIN PORT Interface functions
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void __fastcall TForm1::BOpenComRS232Click(TObject *Sender)
{
    int Add[4] = {StrToInt(EAddress1ComRS232->Text), StrToInt(EAddress2ComRS232->Text), StrToInt(EAddress3ComRS232->Text), StrToInt(EAddress4ComRS232->Text)};

    if(!FMod_TCP_BOX_OpenConnection_RS232(Add, Data_Received_RS232, Com_Event_RS232, &ComID_RS232))
        SBComRS232->Panels->Items[1]->Text = "Open failed";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BCloseComRS232Click(TObject *Sender)
{
    FMod_TCP_BOX_CloseConnection(&ComID_RS232);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BSendComRS232Click(TObject *Sender)
{
    Byte Buffer[4] = "1234";

    FMod_TCP_BOX_SendData_RS232(Buffer, 4, ComID_RS232);
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//      GENERAL Functions
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void __fastcall TForm1::BScanNetworkClick(TObject *Sender)
{
    FMod_SModule ModuleList[10];

    int NbModule = FMod_TCP_BOX_ScanNetwork(ModuleList, 10);

    SBComGeneral->Panels->Items[1]->Text = IntToStr(NbModule) + "Module found";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BChangeIPAddClick(TObject *Sender)
{
    int Mac[6] =  {0x00, 0x50, 0xC2, 0x30, 0x80, 0x00};
    int IpAdd[4] = {StrToInt(ENewAddress1->Text), StrToInt(ENewAddress2->Text), StrToInt(ENewAddress3->Text), StrToInt(ENewAddress4->Text)};
    int Mask[4] = {255, 255, 0, 0};

    if(!FMod_TCP_BOX_ChangeIPAddress(Mac, IpAdd, Mask))
        SBComGeneral->Panels->Items[1]->Text = "ChangeIPAddress failed";
    else
        SBComGeneral->Panels->Items[1]->Text = "ChangeIPAddress success";
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//      Translate State from integer to string
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void TForm1::TranslateState(int State, AnsiString *StateStr)
{
    switch(State)
    {
        case State_Closed:
            *StateStr = "Connection Closed";
        break;
        case State_Opened:
            *StateStr = "Connection Opened";
        break;
        case State_Error:
            *StateStr = "Connection Error";
        break;
        case State_Opening:
            *StateStr = "Connection Opening";
        break;
        case State_Closing:
            *StateStr = "Connection Closing";
        break;
        default:
            *StateStr = "State Unknown";
    }
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------


